suss(5) "Turnstile Backend" "Simple User Session Service Usage Guide"

# DESCRIPTION

*suss* is a _turnstiled(8)_ backend for starting user session services
by executing scripts and binaries in any _$USER_SESSION_DIRS_ directories
(e.g. _$HOME/.user_session.d/_) when a user first logs in to a host,
and then stop the services when the last login ends.

The service startup scripts (and binaries) in _$USER_SESSION_DIRS_ are
run by *suss* as _turnstiled(8)_ backend prior to the user's first
login session. The service startup must terminate and return quickly,
as otherwise the user login will hang.

Long running services should be spawned to be background subprocesses
that retain the session-id while running asynchronously, while the
service start script (or binary) must return directly. Upon the user's
final logout, i.e. when the user doesn't have any ongoing session on
the host, all services with the session-id are terminated by means of
the successive signals TERM and KILL.

The *suss* user session service manager also handles signals HUP and
TERM itself by terminating all running services (of its session
id) before exiting. _turnstiled(8)_ then will restart the *suss*
service manager anew for a new start of the user session services.

Note that session service start filenames consist entirely of ASCII
uppercase and lowercase letters, digits, underscore, hyphen (minus) or
plus. Files with other characters in their names are silently ignored,
as are any sub directories regardless of their names.

One may for instance disable a service by affixing a period to the
service start file name. That would also make the file a "hidden
file". If then *suss* is sent a HUP signal, it will terminate all
currently running services, including the ones just disabled, and
subsequently restart only those that are still enabled.

# EXAMPLES

The following are examples of session service startup scripts for
running a long term service, "myservice".

## Simple Non-Repeating Session Action

This example illustrates a control script for a simple non-repeating
"myservice" service.

	#!/bin/sh++
myaction &++
true

Note that if the "myservice service is indeed simple and known to
terminate quickly in all circumstances, then it might not need a
service control script at all, but would be installed either directly
or with a symbolic link in the _$HOME/user_session.d/_ directory.

## Simple, Uncontrolled Repetition

This example illustrates a simple, uncontrolled repetition of a
"myservice", which merely re-runs the service repeatedly, should it
exit:

	#!/bin/sh++
while true ; do myservice ; done &++
true

## Propagating Environment Variables

If your user service scripts need to set variables in the user's environment,
add this fragment to _$HOME/.profile_:

	\[ -r "$XDG_RUNTIME_DIR/profile" \] && . "$XDG_RUNTIME_DIR/profile

and append the export to _$XDG_RUNTIME_DIR/profile_ in your user service script:

	#!/bin/sh++
SSH_AUTH_SOCK=$XDG_RUNTIME_DIR/openssh_agent++
ssh-agent -D -a $SSH_AUTH_SOCK &++
echo "export SSH_AUTH_SOCK=$SSH_AUTH_SOCK" >> $XDG_RUNTIME_DIR/profile

## Daemon Based Repetition

This example illustrates using daemon(1) for a more controlled
repetition of the "myservice" service, where the service is re-run
repeatedly under _daemon(1)_ control, should it exit:

	#!/bin/sh++
daemon -f -r -- myservice &++
true

# Configuration

*suss* uses a configuration file named *suss.conf* in the
_turnstiled(8)_ backend configurations directory. This file is a
POSIX sh fragment that gets sourced into *suss* on demand.

Currently the only configuration is for _$USER_SESSION_DIRS_ which
nominates the directory for user session service start programs.

# CONTRIBUTORS

Mark Hindley <mark@hindley.org.uk>++
Ralph Ronnquist <rrq@rrq.au>
